<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    * 
    * Classe che definisce i Gruppi
    */

    class Gruppo {
        private $db;
        private $id;
        private $nome;
        private $tipo;
        private $descrizione;
        private $dataCreazione;
        
        function __construct($db, $id) {
            $this->db = $db;
            $this->id = $id;
            $this->nome = "";
            $this->tipo = "";
            $this->descrizione = 0;
            $this->dataCreazione = "";
        }
        
        function crea() {
            $dataCreazione = date("Y-m-d");
            $queryControlloTagEsistente ="SELECT * FROM geec_gruppi WHERE nome LIKE '$this->nome'";
            $ris = $this->db->eseguiQueryLettura($queryControlloTagEsistente);
            if($ris->num_rows == 0) {
                $query = "INSERT INTO geec_gruppi (`id`, `nome`, `tipo`, `descrizione`, `dataCreazione`) VALUES (NULL,'$this->nome','$this->tipo','$this->descrizione','$dataCreazione')";
                $this->id = $this->db->eseguiQueryCreazione($query);
                return $this->id;
            }
            else {
                return -1;
            }
        }

        function modifica() {
            $query = "UPDATE geec_gruppi SET nome='$this->nome', descrizione ='$this->descrizione' WHERE id = $this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function associaUtenteAQuestoGruppo($idArticolo) {
            $query = "INSERT INTO geecB_associazioniTagArticoli VALUES(NULL,$idArticolo,$this->id);";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_gruppi",$this->id);
        }
                
        function stampaElementoGruppo() {
            $datiGruppo   = $this->db->leggiSingolaRiga("geec_gruppi",$this->id);
            $numeroUtenti = $this->db->contaRigheTabella("geec_gruppiUtenti",array("idGruppo"=>$this->id));
            $nomeEscape = filter_var($datiGruppo["nome"],FILTER_SANITIZE_ADD_SLASHES);
            echo"<div id=\"gruppo{$datiGruppo["id"]}\" class=\"col-sm-6 col-lg-4\">
                    <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                            <p class=\"mb-0\"><em><strong>{$datiGruppo["nome"]}</strong></em>  </p>
                            <small><em>$numeroUtenti utenti</em>  </small>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Visualizza utenti\" onclick=\"location.href='elencoUtenti.php?idGruppo={$datiGruppo["id"]}';\"><i class=\"fas fa-users\"></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura elemento\" onclick=\"modificaGruppo({$datiGruppo["id"]},'$nomeEscape','{$datiGruppo["descrizione"]}')\"><i class=\"fas fa-edit\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaGruppo({$datiGruppo["id"]},'$nomeEscape')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>
                </div>";
        }
        
        // getter & setter
        
        function getId() {
            return $this->id;
        }

        function getTipo() {
            return $this->tipo;
        }
        
        function getNome() {
            return $this->nome;
        }

        function getDescrizione() {
            return $this->descrizione;
        }
        
        function getDataCreazione() {
            return $this->dataCreazione;
        }

        function setId($id) {
            $this->id = $id;
        }

        function setTipo($tipo) {
            $this->tipo = $tipo;
        }
        
        function setNome($nome) {
            $this->nome = $nome;
        }

        function setDescrizione($descrizione) {
            $this->descrizione = $descrizione;
        }
        
        function setDataCreazione($dataCreazione) {
            $this->dataCreazione = $dataCreazione;
        }

    }
